var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import pMap from 'p-map';
import { getProcessConcurrency } from '../../shared/processConcurrency.js';
import { calculateIndividualFileMetrics } from './calculateIndividualFileMetrics.js';
export const calculateAllFileMetrics = (processedFiles, tokenCounter, progressCallback) => __awaiter(void 0, void 0, void 0, function* () {
    return yield pMap(processedFiles, (file, index) => calculateIndividualFileMetrics(file, index, processedFiles.length, tokenCounter, progressCallback), {
        concurrency: getProcessConcurrency(),
    });
});
//# sourceMappingURL=calculateAllFileMetrics.js.map